#version 140
#extension GL_EXT_gpu_shader4 : enable
// Lining MatterMod01.fsh  by asiJa

//https://www.shadertoy.com/view/Wlsfz7
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels


#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize


//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Playing with image deformation by velocity field (vx,vy) = Sum_i{ (sin(k_i*y),sin(k_i*x)) } where frequnecies k_i vary in time


vec2 flow(vec2 p){     
    const int n  = 7;
    float t      = iTime*1.2 + 3.36545588;
    vec2  dp     = vec2(0.);
    float ctot   = 0.0;
    for(int i=0; i<n; i++ ){
        float fi = float(i);
        float c  = sin(t*0.1 + fi);
        dp      += sin(p.yx*fi)*c/(0.1+fi);
        ctot    += abs(c);
    }
    return 2.*dp/ctot;
}

void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 p = gl_FragCoord.xy/iResolution.y;
    
   	vec2 rot = vec2(-0.70710678118,0.70710678118);
    p += vec2(-0.03,-0.05);
    p = vec2(rot.x*p.x - rot.y*p.y, rot.y*p.x + rot.x*p.y);
    
    
    //p +=vec2(0.6,0.3);
    float dt = 0.05;
    float freq=10.0;
    for(int i=0;i<16;i++){ p += flow(p*freq)*dt; } 
    vec4 c = texture2D(iChannel0,p);
    gl_FragColor = c;
}